package com.bitbof.escape.entities;

import java.util.ArrayList;
import java.util.List;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;

import com.bitbof.escape.Art;

public class OldWorld {
	

	public double timeFactor = 1f;
	
	public List<Entity> entities;
	public List<ElasticHook> hooks;
	public Player player;
	
	public List<Entity> addQueue;
	private long tick = 0;
	
	public OldWorld() {
		entities = new ArrayList<Entity>();
		addQueue = new ArrayList<Entity>();
		//entities.add(new Blob(this, null, 0, 0, 900));
		
		{//generate elatstic hooks
			hooks = new ArrayList<ElasticHook>();
			for(int i = 0 ; i < 10; i++) {
				ElasticHook h = new ElasticHook();
				h.pos.x = (float) (600*(Math.random()-0.5));
				h.pos.y = (float) (600*(Math.random()-0.5));
				hooks.add(h);
			}
		}
		player = null;//new Player(this);
	}
	
	public void tick() {
		entities.addAll(addQueue);
		addQueue.clear();
		for(int i = 0; i < entities.size(); i++) {
			Entity e = entities.get(i);
			e.tick();
			if(!e.isAlive()){
				entities.remove(i--);
			}
		}
		for(ElasticHook h: hooks){
			h.tick();
		}
		/*player.tick();
		if(!player.alive)
			player = null;*/
		tick++;
		
	}
	public void render() {
		drawBackground();
		
		//entities
		for(Entity e: entities) {
			e.render();
		}
		for(ElasticHook eh: hooks) {
			eh.render();
		}
		//player.render();
		
	}
	
	public void add(Entity e) {
		addQueue.add(e);
	}
	
	public void drawBackground()  {
		{
			Art.bg01.bind();
			GL11.glPushMatrix();
			//GL11.glTranslated(player.pos.x, player.pos.y, 0);
			GL11.glTranslated(Math.sin(tick/100f+0.3*timeFactor)*1000*timeFactor+Math.cos(tick/140f+0.1*timeFactor)*1000*timeFactor, Math.sin(tick/80f+0.5*timeFactor)*1000*timeFactor+Math.cos(-tick/120f+0.4*timeFactor)*1000*timeFactor, 0);
	
			GL11.glColor4f(1, 1, 1, 0.5f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(0, 0, 0, 1);
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
		{
			GL11.glPushMatrix();
			//GL11.glTranslated(player.pos.x, player.pos.y, 0);
			GL11.glTranslated(Math.sin(-tick/300f+0.3*timeFactor)*2000*timeFactor+Math.cos(tick/130f+0.1*timeFactor)*400*timeFactor, Math.sin(-tick/80f+0.5*timeFactor)*1000*timeFactor+Math.cos(-tick/1200f+0.4*timeFactor)*2000*timeFactor, 0);
	
			GL11.glColor4f(1, 1, 1, 0.5f);
	
			Texture texture = Art.blob;
			// rotate square according to angle
			GL11.glRotatef(1, 0, 0, (float) (Math.sin(-tick/300f+0.3*timeFactor)*2000*timeFactor+Math.cos(tick/130f+0.1*timeFactor)*400*timeFactor));
			GL11.glScalef(8000, 8000, 0);
			GL11.glBegin(GL11.GL_QUADS);
				GL11.glTexCoord2f(0, 0);
				GL11.glVertex2f(-0.5f, -0.5f);
				GL11.glTexCoord2f(0, texture.getHeight());
				GL11.glVertex2f(0.5f, -0.5f);
				GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
				GL11.glVertex2f(0.5f, 0.5f);
				GL11.glTexCoord2f(texture.getWidth(), 0);
				GL11.glVertex2f(-0.5f, 0.5f);
			GL11.glEnd();
	
			GL11.glPopMatrix();
		}
	}
}
